﻿//////////////////////////////////////////////
// ContentLoader.h
//
//////////////////////////////////////////////

/// Defines / macro --------------------------

#pragma once

/// Forward declarations ---------------------

namespace nkGraphics
{
	class Compositor ;
	class System ;
}

namespace nkExport
{
	class Node ;
	class Exportable ;
}

/// Includes ---------------------------------

// nkGraphics
#include "ContentLoadResult.h"

#include "../Dll/DllDefines.h"

// nkExport
#include <NilkinsExport/Exporter/ExporterLoadResult.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ContentLoader final
	{			
		public :

			// Constructor
			ContentLoader (System* system) noexcept ;

			// Fonctions pratiques
			nkExport::ExporterLoadResult inputData (nkMemory::StringView filePath) ;
			nkMemory::String inputDataStr (nkMemory::StringView filePath) ;
			nkExport::ExporterLoadResult inputDataSources (nkMemory::StringView sources) ;
			bool outputData (nkMemory::StringView content, nkMemory::StringView path) ;
		
			// Save
			bool saveTreeDeclaration (nkExport::Node* tree, nkMemory::StringView pathFromData) ;
			bool saveObjectDeclaration (nkExport::Exportable* object, nkMemory::StringView pathFromData) ;

			// Les fonctions spéciales pour chaque type
			// Elles concernent le chargement du coup
			// Pour les textures
			ContentLoadResultTexture loadTextureDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultTexture processTextureSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultTexture processTextureTree (nkExport::Node* tree, bool loadResource = true) ;
			// Samplers
			ContentLoadResultSampler loadSamplerDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultSampler processSamplerSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultSampler processSamplerTree (nkExport::Node* tree, bool loadResource = true) ;
			// Shaders Program
			ContentLoadResultProgram loadShaderProgramDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultProgram processShaderProgramSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultProgram processShaderProgramTree (nkExport::Node* tree, bool loadResource = true) ;
			// Shader Memory Slot
			ContentLoadResultShaderMemorySlot loadShaderMemorySlotDeclaration (nkMemory::StringView pathFromData) ;
			ContentLoadResultShaderMemorySlot processShaderMemorySlotSources (nkMemory::StringView sources) ;
			ContentLoadResultShaderMemorySlot processShaderMemorySlotDeclarationTree (nkExport::Node* tree) ;
			// Constant Buffer
			ContentLoadResultConstantBuffer loadConstantBufferDeclaration (nkMemory::StringView pathFromData) ;
			ContentLoadResultConstantBuffer processConstantBufferSources (nkMemory::StringView sources) ;
			ContentLoadResultConstantBuffer processConstantBufferDeclarationTree (nkExport::Node* tree) ;
			// Compute Buffer
			ContentLoadResultBuffer loadBufferDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultBuffer processBufferSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultBuffer processBufferDeclarationTree (nkExport::Node* tree, bool loadResource = true) ;
			// Shader
			ContentLoadResultShader loadShaderDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultShader processShaderDeclarationSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultShader processShaderDeclarationTree (nkExport::Node* tree, bool loadResource = true) ;
			// Compositor
			ContentLoadResultCompositor loadCompositorDeclaration (nkMemory::StringView pathFromData) ;
			ContentLoadResultCompositor processCompositorSources (nkMemory::StringView sources) ;
			ContentLoadResultCompositor processCompositorTree (nkExport::Node* tree) ;
			// Meshes
			ContentLoadResultMesh loadMeshDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultMesh processMeshSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultMesh processMeshTree (nkExport::Node* tree, bool loadResource = true) ;
			// Nodes
			ContentLoadResultNode loadNodeDeclaration (nkMemory::StringView pathFromData) ;
			ContentLoadResultNode processNodeSources (nkMemory::StringView sources) ;
			ContentLoadResultNode processNodeTree (nkExport::Node* tree) ;
			// Blend States
			ContentLoadResultBlendState loadBlendStateDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultBlendState processBlendStateSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultBlendState processBlendStateTree (nkExport::Node* tree, bool loadResource = true) ;
			// Depth Stencil States
			ContentLoadResultDepthStencilState loadDepthStencilStateDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultDepthStencilState processDepthStencilStateSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultDepthStencilState processDepthStencilStateTree (nkExport::Node* tree, bool loadResource = true) ;
			// Raster States
			ContentLoadResultRasterState loadRasterStateDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultRasterState processRasterStateSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultRasterState processRasterStateTree (nkExport::Node* tree, bool loadResource = true) ;
			// Camera
			ContentLoadResultCamera loadCameraDeclaration (nkMemory::StringView pathFromData) ;
			ContentLoadResultCamera processCameraSources (nkMemory::StringView sources) ;
			ContentLoadResultCamera processCameraTree (nkExport::Node* tree) ;
			// Render Queues
			ContentLoadResultRenderQueue loadRenderQueueDeclaration (nkMemory::StringView pathFromData) ;
			ContentLoadResultRenderQueue processRenderQueueSources (nkMemory::StringView sources) ;
			ContentLoadResultRenderQueue processRenderQueueTree (nkExport::Node* tree) ;

			// Pour des objets dépendants d'autres
			// Compositor Node
			ContentLoadResultCompositorNode appendCompositorNodeFromFile (nkMemory::StringView pathFromData, Compositor* parent) ;
			ContentLoadResultCompositorNode appendCompositorNodeFromSources (nkMemory::StringView sources, Compositor* parent) ;
			ContentLoadResultCompositorNode appendCompositorNodeFromTree (nkExport::Node* tree, Compositor* parent) ;

		private :

			// Attributes
			System* _system ;
			unsigned int _nodeCounter ;
	} ;
}